<?php include __DIR__ . '/includes/header.php';

$soils = $pdo->query("SELECT id, name FROM soil_types ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)($_POST['id'] ?? 0);
    $soilTypeId = (int)($_POST['soil_type_id'] ?? 0);
    $season = trim($_POST['season'] ?? 'Any');
    $phMin = floatval($_POST['ph_min'] ?? 0);
    $phMax = floatval($_POST['ph_max'] ?? 14);
    $recommended = trim($_POST['recommended_crops'] ?? '');
    $seedRate = trim($_POST['seed_rate'] ?? '');
    $sowingWindow = trim($_POST['sowing_window'] ?? '');
    $fertSchedule = trim($_POST['fertilization_schedule'] ?? '');
    $organic = trim($_POST['organic_amendments'] ?? '');
    $pest = trim($_POST['pest_watchlist'] ?? '');
    $isActive = isset($_POST['is_active']) ? 1 : 0;

    if ($soilTypeId && $recommended !== '') {
        if ($id) {
            $stmt = $pdo->prepare("UPDATE advisory_rules SET soil_type_id=?, season=?, ph_min=?, ph_max=?, recommended_crops=?, seed_rate=?, sowing_window=?, fertilization_schedule=?, organic_amendments=?, pest_watchlist=?, is_active=? WHERE id=?");
            $stmt->execute([$soilTypeId, $season, $phMin, $phMax, $recommended, $seedRate, $sowingWindow, $fertSchedule, $organic, $pest, $isActive, $id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO advisory_rules (soil_type_id, season, ph_min, ph_max, recommended_crops, seed_rate, sowing_window, fertilization_schedule, organic_amendments, pest_watchlist, is_active) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->execute([$soilTypeId, $season, $phMin, $phMax, $recommended, $seedRate, $sowingWindow, $fertSchedule, $organic, $pest, $isActive]);
        }
    }
}

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $pdo->prepare("DELETE FROM advisory_rules WHERE id=?")->execute([$id]);
    header('Location: advisory_rules.php'); exit;
}

$edit = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM advisory_rules WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch(PDO::FETCH_ASSOC);
}

$list = $pdo->query("SELECT ar.*, s.name AS soil_name FROM advisory_rules ar LEFT JOIN soil_types s ON s.id = ar.soil_type_id ORDER BY ar.id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<h4 class="mb-3">Rule-Based Advisory</h4>
<div class="row g-3">
    <div class="col-lg-5">
        <div class="card p-3">
            <h6 class="card-title mb-2"><?= $edit ? 'Edit Rule' : 'Add Rule' ?></h6>
            <form method="post">
                <input type="hidden" name="id" value="<?= htmlspecialchars($edit['id'] ?? '') ?>">
                <div class="mb-2">
                    <label class="form-label small">Soil Type</label>
                    <select name="soil_type_id" class="form-select form-select-sm" required>
                        <option value="">Select</option>
                        <?php foreach ($soils as $s): ?>
                            <option value="<?= $s['id'] ?>" <?= ($edit['soil_type_id'] ?? '') == $s['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($s['name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="row g-2 mb-2">
                    <div class="col-4">
                        <label class="form-label small">Season</label>
                        <select name="season" class="form-select form-select-sm">
                            <?php $seasonSel = $edit['season'] ?? 'Any'; ?>
                            <option value="Any" <?= $seasonSel==='Any'?'selected':'' ?>>Any</option>
                            <option value="Kharif" <?= $seasonSel==='Kharif'?'selected':'' ?>>Kharif</option>
                            <option value="Rabi" <?= $seasonSel==='Rabi'?'selected':'' ?>>Rabi</option>
                            <option value="Zaid" <?= $seasonSel==='Zaid'?'selected':'' ?>>Zaid</option>
                        </select>
                    </div>
                    <div class="col-4">
                        <label class="form-label small">pH Min</label>
                        <input type="number" step="0.01" class="form-control form-control-sm" name="ph_min" value="<?= htmlspecialchars($edit['ph_min'] ?? 6.0) ?>">
                    </div>
                    <div class="col-4">
                        <label class="form-label small">pH Max</label>
                        <input type="number" step="0.01" class="form-control form-control-sm" name="ph_max" value="<?= htmlspecialchars($edit['ph_max'] ?? 7.5) ?>">
                    </div>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Recommended Crops</label>
                    <textarea class="form-control form-control-sm" name="recommended_crops" rows="2" required><?= htmlspecialchars($edit['recommended_crops'] ?? '') ?></textarea>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Seed Rate</label>
                    <textarea class="form-control form-control-sm" name="seed_rate" rows="2"><?= htmlspecialchars($edit['seed_rate'] ?? '') ?></textarea>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Sowing Window</label>
                    <textarea class="form-control form-control-sm" name="sowing_window" rows="2"><?= htmlspecialchars($edit['sowing_window'] ?? '') ?></textarea>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Fertilization Schedule</label>
                    <textarea class="form-control form-control-sm" name="fertilization_schedule" rows="2"><?= htmlspecialchars($edit['fertilization_schedule'] ?? '') ?></textarea>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Organic Amendments</label>
                    <textarea class="form-control form-control-sm" name="organic_amendments" rows="2"><?= htmlspecialchars($edit['organic_amendments'] ?? '') ?></textarea>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Pest/Disease Watchlist</label>
                    <textarea class="form-control form-control-sm" name="pest_watchlist" rows="2"><?= htmlspecialchars($edit['pest_watchlist'] ?? '') ?></textarea>
                </div>
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?= !isset($edit['is_active']) || $edit['is_active'] ? 'checked' : '' ?>>
                    <label class="form-check-label small" for="is_active">Active</label>
                </div>
                <button class="btn btn-success btn-sm w-100" type="submit"><?= $edit ? 'Update Rule' : 'Create Rule' ?></button>
            </form>
        </div>
    </div>
    <div class="col-lg-7">
        <div class="card p-3">
            <h6 class="card-title mb-2">Existing Rules</h6>
            <div class="table-responsive small">
                <table class="table table-dark table-sm">
                    <thead><tr><th>Soil</th><th>Season</th><th>pH</th><th>Crops</th><th>Active</th><th></th></tr></thead>
                    <tbody>
                        <?php foreach ($list as $r): ?>
                            <tr>
                                <td><?= htmlspecialchars($r['soil_name']) ?></td>
                                <td><?= htmlspecialchars($r['season']) ?></td>
                                <td><?= htmlspecialchars($r['ph_min']) ?>–<?= htmlspecialchars($r['ph_max']) ?></td>
                                <td><?= htmlspecialchars(mb_strimwidth($r['recommended_crops'], 0, 26, '…')) ?></td>
                                <td><?= $r['is_active'] ? 'Yes' : 'No' ?></td>
                                <td>
                                    <a href="?edit=<?= $r['id'] ?>" class="btn btn-outline-light btn-sm">Edit</a>
                                    <a href="?delete=<?= $r['id'] ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete rule?')">Del</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (!$list): ?>
                            <tr><td colspan="6" class="text-center text-gray-500">No rules defined.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
