<?php include __DIR__ . '/includes/header.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $isActive = isset($_POST['is_active']) ? 1 : 0;
    if ($name !== '') {
        if (!empty($_POST['id'])) {
            $id = (int)$_POST['id'];
            $stmt = $pdo->prepare("UPDATE categories SET name=?, description=?, is_active=? WHERE id=?");
            $stmt->execute([$name, $description, $isActive, $id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO categories (name, description, is_active) VALUES (?,?,?)");
            $stmt->execute([$name, $description, $isActive]);
        }
    }
}

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $pdo->prepare("DELETE FROM categories WHERE id=?")->execute([$id]);
    header('Location: categories.php'); exit;
}

$edit = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM categories WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch(PDO::FETCH_ASSOC);
}

$list = $pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
?>
<h4 class="mb-3">Categories</h4>
<div class="row g-3">
    <div class="col-md-4">
        <div class="card p-3">
            <h6 class="card-title mb-2"><?= $edit ? 'Edit Category' : 'Add Category' ?></h6>
            <form method="post">
                <input type="hidden" name="id" value="<?= htmlspecialchars($edit['id'] ?? '') ?>">
                <div class="mb-2">
                    <label class="form-label small">Name</label>
                    <input class="form-control form-control-sm" name="name" required value="<?= htmlspecialchars($edit['name'] ?? '') ?>">
                </div>
                <div class="mb-2">
                    <label class="form-label small">Description</label>
                    <textarea class="form-control form-control-sm" name="description" rows="2"><?= htmlspecialchars($edit['description'] ?? '') ?></textarea>
                </div>
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox" name="is_active" id="is_active" <?= !isset($edit['is_active']) || $edit['is_active'] ? 'checked' : '' ?>>
                    <label class="form-check-label small" for="is_active">Active</label>
                </div>
                <button class="btn btn-success btn-sm w-100" type="submit"><?= $edit ? 'Update' : 'Create' ?></button>
            </form>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card p-3">
            <h6 class="card-title mb-2">All Categories</h6>
            <div class="table-responsive small">
                <table class="table table-dark table-sm align-middle">
                    <thead><tr><th>Name</th><th>Description</th><th>Active</th><th></th></tr></thead>
                    <tbody>
                        <?php foreach ($list as $c): ?>
                            <tr>
                                <td><?= htmlspecialchars($c['name']) ?></td>
                                <td><?= htmlspecialchars($c['description']) ?></td>
                                <td><?= $c['is_active'] ? 'Yes' : 'No' ?></td>
                                <td>
                                    <a href="?edit=<?= $c['id'] ?>" class="btn btn-outline-light btn-sm">Edit</a>
                                    <a href="?delete=<?= $c['id'] ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete category?')">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (!$list): ?>
                            <tr><td colspan="4" class="text-center text-gray-500">No categories yet.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
