<?php include __DIR__ . '/includes/header.php'; ?>

<?php
// KPIs
$today = date('Y-m-d');
$ordersToday = $pdo->prepare("SELECT COUNT(*) FROM orders WHERE DATE(created_at) = ?");
$ordersToday->execute([$today]);
$ordersTodayCount = $ordersToday->fetchColumn();

$pendingOrders = $pdo->query("SELECT COUNT(*) FROM orders WHERE status = 'Pending'")->fetchColumn();
$lowStock = $pdo->query("SELECT COUNT(*) FROM products WHERE stock <= min_stock AND is_active = 1")->fetchColumn();
$newUsers = $pdo->prepare("SELECT COUNT(*) FROM users WHERE DATE(created_at) = ?");
$newUsers->execute([$today]);
$newUsersCount = $newUsers->fetchColumn();
$supportOpen = $pdo->query("SELECT COUNT(*) FROM support_tickets WHERE status = 'Open'")->fetchColumn();
$soilPending = $pdo->query("SELECT COUNT(*) FROM soil_tests WHERE status = 'Pending'")->fetchColumn();
?>
<div class="row g-3 mb-3">
    <div class="col-md-3">
        <div class="card p-3">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <div class="card-title text-muted mb-1">Today's Orders</div>
                    <div class="kpi-value"><?= $ordersTodayCount ?></div>
                </div>
                <div class="badge bg-success-subtle text-success rounded-circle p-3">
                    <i class="bi bi-bag"></i>
                </div>
            </div>
            <div class="small text-gray-500">Pending: <?= $pendingOrders ?></div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card p-3">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <div class="card-title text-muted mb-1">Low Stock</div>
                    <div class="kpi-value"><?= $lowStock ?></div>
                </div>
                <div class="badge bg-danger-subtle text-danger rounded-circle p-3">
                    <i class="bi bi-exclamation-triangle"></i>
                </div>
            </div>
            <div class="small text-gray-500">Products below threshold</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card p-3">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <div class="card-title text-muted mb-1">New Users Today</div>
                    <div class="kpi-value"><?= $newUsersCount ?></div>
                </div>
                <div class="badge bg-info-subtle text-info rounded-circle p-3">
                    <i class="bi bi-person-plus"></i>
                </div>
            </div>
            <div class="small text-gray-500">Registrations</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card p-3">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <div class="card-title text-muted mb-1">Support &amp; Soil</div>
                    <div class="kpi-value"><?= $supportOpen + $soilPending ?></div>
                </div>
                <div class="badge bg-warning-subtle text-warning rounded-circle p-3">
                    <i class="bi bi-headset"></i>
                </div>
            </div>
            <div class="small text-gray-500">Open tickets: <?= $supportOpen ?> | Soil tests: <?= $soilPending ?></div>
        </div>
    </div>
</div>

<div class="row g-3">
    <div class="col-lg-8">
        <div class="card p-3">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="card-title mb-0">Recent Orders</h6>
                <a href="orders.php" class="small text-gray-400">View all</a>
            </div>
            <div class="table-responsive small">
                <table class="table table-dark table-sm align-middle">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>User</th>
                            <th>Total</th>
                            <th>Status</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $recent = $pdo->query("SELECT o.*, u.name AS user_name FROM orders o LEFT JOIN users u ON u.id = o.user_id ORDER BY o.created_at DESC LIMIT 6");
                        foreach ($recent as $row): ?>
                            <tr>
                                <td>#<?= $row['id'] ?></td>
                                <td><?= htmlspecialchars($row['user_name']) ?></td>
                                <td>₹<?= number_format($row['cod_amount'], 2) ?></td>
                                <td><span class="badge bg-secondary"><?= htmlspecialchars($row['status']) ?></span></td>
                                <td><?= htmlspecialchars($row['created_at']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (!$recent->rowCount()): ?>
                            <tr><td colspan="5" class="text-center text-gray-500">No orders yet.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="card p-3 mb-3">
            <h6 class="card-title mb-2">Pending Soil Tests</h6>
            <div class="small">
                <?php
                $soil = $pdo->query("SELECT st.*, p.name AS plot_name, u.name AS user_name FROM soil_tests st 
                    LEFT JOIN plots p ON p.id = st.plot_id 
                    LEFT JOIN users u ON u.id = st.user_id 
                    WHERE st.status = 'Pending' 
                    ORDER BY st.created_at DESC LIMIT 5");
                foreach ($soil as $s): ?>
                    <div class="mb-2">
                        <div class="fw-semibold"><?= htmlspecialchars($s['plot_name']) ?> – <?= htmlspecialchars($s['user_name']) ?></div>
                        <div class="text-gray-500 small">pH: <?= htmlspecialchars($s['ph_value']) ?> | Texture: <?= htmlspecialchars($s['texture']) ?></div>
                    </div>
                <?php endforeach; ?>
                <?php if (!$soil->rowCount()): ?>
                    <div class="text-gray-500">No pending soil-test requests.</div>
                <?php endif; ?>
            </div>
        </div>
        <div class="card p-3">
            <h6 class="card-title mb-2">Open Support Tickets</h6>
            <div class="small">
                <?php
                $tickets = $pdo->query("SELECT st.*, u.name AS user_name FROM support_tickets st 
                    LEFT JOIN users u ON u.id = st.user_id 
                    WHERE st.status = 'Open' 
                    ORDER BY st.created_at DESC LIMIT 5");
                foreach ($tickets as $t): ?>
                    <div class="mb-2">
                        <div class="fw-semibold"><?= htmlspecialchars($t['subject']) ?></div>
                        <div class="text-gray-500 small">From <?= htmlspecialchars($t['user_name']) ?> at <?= htmlspecialchars($t['created_at']) ?></div>
                    </div>
                <?php endforeach; ?>
                <?php if (!$tickets->rowCount()): ?>
                    <div class="text-gray-500">No open tickets.</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
