<?php include __DIR__ . '/includes/header.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)($_POST['id'] ?? 0);
    $name = trim($_POST['name'] ?? '');
    $phMin = $_POST['ph_min'] !== '' ? floatval($_POST['ph_min']) : null;
    $phMax = $_POST['ph_max'] !== '' ? floatval($_POST['ph_max']) : null;
    $texture = trim($_POST['texture'] ?? '');
    $drainage = trim($_POST['drainage'] ?? '');
    $recommended = trim($_POST['recommended_crops'] ?? '');
    $description = trim($_POST['description'] ?? '');
    if ($name !== '') {
        if ($id) {
            $stmt = $pdo->prepare("UPDATE soil_types SET name=?, ph_min=?, ph_max=?, texture=?, drainage=?, recommended_crops=?, description=? WHERE id=?");
            $stmt->execute([$name, $phMin, $phMax, $texture, $drainage, $recommended, $description, $id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO soil_types (name, ph_min, ph_max, texture, drainage, recommended_crops, description) VALUES (?,?,?,?,?,?,?)");
            $stmt->execute([$name, $phMin, $phMax, $texture, $drainage, $recommended, $description]);
        }
    }
}

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $pdo->prepare("DELETE FROM soil_types WHERE id=?")->execute([$id]);
    header('Location: soil_types.php'); exit;
}

$edit = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM soil_types WHERE id=?");
    $stmt->execute([$id]);
    $edit = $stmt->fetch(PDO::FETCH_ASSOC);
}

$list = $pdo->query("SELECT * FROM soil_types ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
?>
<h4 class="mb-3">Soil Types</h4>
<div class="row g-3">
    <div class="col-md-5">
        <div class="card p-3">
            <h6 class="card-title mb-2"><?= $edit ? 'Edit Soil Type' : 'Add Soil Type' ?></h6>
            <form method="post">
                <input type="hidden" name="id" value="<?= htmlspecialchars($edit['id'] ?? '') ?>">
                <div class="mb-2">
                    <label class="form-label small">Name</label>
                    <input class="form-control form-control-sm" name="name" required value="<?= htmlspecialchars($edit['name'] ?? '') ?>">
                </div>
                <div class="row g-2 mb-2">
                    <div class="col-6">
                        <label class="form-label small">pH Min</label>
                        <input type="number" step="0.01" class="form-control form-control-sm" name="ph_min" value="<?= htmlspecialchars($edit['ph_min'] ?? '') ?>">
                    </div>
                    <div class="col-6">
                        <label class="form-label small">pH Max</label>
                        <input type="number" step="0.01" class="form-control form-control-sm" name="ph_max" value="<?= htmlspecialchars($edit['ph_max'] ?? '') ?>">
                    </div>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Texture</label>
                    <input class="form-control form-control-sm" name="texture" value="<?= htmlspecialchars($edit['texture'] ?? '') ?>">
                </div>
                <div class="mb-2">
                    <label class="form-label small">Drainage</label>
                    <input class="form-control form-control-sm" name="drainage" value="<?= htmlspecialchars($edit['drainage'] ?? '') ?>">
                </div>
                <div class="mb-2">
                    <label class="form-label small">Recommended Crops</label>
                    <textarea class="form-control form-control-sm" name="recommended_crops" rows="2"><?= htmlspecialchars($edit['recommended_crops'] ?? '') ?></textarea>
                </div>
                <div class="mb-2">
                    <label class="form-label small">Description</label>
                    <textarea class="form-control form-control-sm" name="description" rows="2"><?= htmlspecialchars($edit['description'] ?? '') ?></textarea>
                </div>
                <button class="btn btn-success btn-sm w-100" type="submit"><?= $edit ? 'Update' : 'Create' ?></button>
            </form>
        </div>
    </div>
    <div class="col-md-7">
        <div class="card p-3">
            <h6 class="card-title mb-2">All Soil Types</h6>
            <div class="table-responsive small">
                <table class="table table-dark table-sm">
                    <thead><tr><th>Name</th><th>pH Range</th><th>Texture</th><th></th></tr></thead>
                    <tbody>
                        <?php foreach ($list as $s): ?>
                            <tr>
                                <td><?= htmlspecialchars($s['name']) ?></td>
                                <td><?= htmlspecialchars($s['ph_min']) ?> – <?= htmlspecialchars($s['ph_max']) ?></td>
                                <td><?= htmlspecialchars($s['texture']) ?></td>
                                <td>
                                    <a href="?edit=<?= $s['id'] ?>" class="btn btn-outline-light btn-sm">Edit</a>
                                    <a href="?delete=<?= $s['id'] ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete soil type?')">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (!$list): ?>
                            <tr><td colspan="4" class="text-center text-gray-500">No soil types yet.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
