<?php include __DIR__ . '/includes/header.php';

if (isset($_GET['toggle'])) {
    $id = (int)$_GET['toggle'];
    $stmt = $pdo->prepare("SELECT status FROM users WHERE id=?");
    $stmt->execute([$id]);
    $u = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($u) {
        $new = $u['status'] === 'active' ? 'banned' : 'active';
        $pdo->prepare("UPDATE users SET status=? WHERE id=?")->execute([$new, $id]);
    }
    header('Location: users.php'); exit;
}

$list = $pdo->query("SELECT id, name, email, role, status, created_at FROM users ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<h4 class="mb-3">Users</h4>
<div class="card p-3">
    <div class="table-responsive small">
        <table class="table table-dark table-sm align-middle">
            <thead><tr><th>#</th><th>Name</th><th>Email</th><th>Role</th><th>Status</th><th>Joined</th><th></th></tr></thead>
            <tbody>
                <?php foreach ($list as $u): ?>
                    <tr>
                        <td><?= $u['id'] ?></td>
                        <td><?= htmlspecialchars($u['name']) ?></td>
                        <td><?= htmlspecialchars($u['email']) ?></td>
                        <td><?= htmlspecialchars($u['role']) ?></td>
                        <td><?= htmlspecialchars($u['status']) ?></td>
                        <td><?= htmlspecialchars($u['created_at']) ?></td>
                        <td>
                            <?php if ($u['role'] !== 'super_admin'): ?>
                                <a href="?toggle=<?= $u['id'] ?>" class="btn btn-outline-light btn-sm">
                                    <?= $u['status'] === 'active' ? 'Deactivate' : 'Activate' ?>
                                </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (!$list): ?>
                    <tr><td colspan="7" class="text-center text-gray-500">No users yet.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php include __DIR__ . '/includes/footer.php'; ?>
