<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

if (empty($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}
$userId = $_SESSION['user']['id'];
$plotId = isset($_GET['plot_id']) ? (int)$_GET['plot_id'] : 0;

$plotsStmt = $pdo->prepare("SELECT p.*, s.name AS soil_name FROM plots p LEFT JOIN soil_types s ON s.id = p.soil_type_id WHERE p.user_id = ? ORDER BY p.created_at DESC");
$plotsStmt->execute([$userId]);
$plots = $plotsStmt->fetchAll(PDO::FETCH_ASSOC);

$selectedPlot = null;
foreach ($plots as $p) {
    if ($p['id'] == $plotId) $selectedPlot = $p;
}

$advisory = null;
if ($selectedPlot) {
    // Simple internal rule engine using advisory_rules table
    $ph = $selectedPlot['ph_value'];
    $soilId = $selectedPlot['soil_type_id'];
    $season = 'Rabi'; // demo: could be determined by current month
    if ($ph !== null && $soilId) {
        $stmt = $pdo->prepare("SELECT * FROM advisory_rules 
            WHERE soil_type_id = ? AND is_active = 1 
            AND (season = ? OR season = 'Any')
            AND ph_min <= ? AND ph_max >= ?
            LIMIT 1");
        $stmt->execute([$soilId, $season, $ph, $ph]);
        $advisory = $stmt->fetch(PDO::FETCH_ASSOC);
    }
}
?>
<div class="container my-4">
    <h3 class="mb-3">Smart Advisory</h3>
    <div class="row g-4">
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h6 class="mb-2">Select Plot</h6>
                    <form method="get">
                        <select name="plot_id" class="form-select mb-2" onchange="this.form.submit()">
                            <option value="">Choose plot</option>
                            <?php foreach ($plots as $p): ?>
                                <option value="<?= $p['id'] ?>" <?= $plotId == $p['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($p['name']) ?> (pH <?= $p['ph_value'] !== null ? htmlspecialchars($p['ph_value']) : 'N/A' ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <noscript><button class="btn btn-success btn-sm" type="submit">Get Advisory</button></noscript>
                    </form>
                    <p class="small text-muted mb-0">Tip: Make sure your plot has soil type and pH value filled in.</p>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <?php if (!$selectedPlot): ?>
                <p class="text-muted">Select a plot to generate advisory.</p>
            <?php elseif (!$advisory): ?>
                <div class="alert alert-info">
                    No matching rule found for this plot's soil &amp; pH. Admin can add rules in back office.
                </div>
            <?php else: ?>
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="mb-2">Advisory for <?= htmlspecialchars($selectedPlot['name']) ?></h5>
                        <p class="small text-muted mb-3">
                            Soil: <?= htmlspecialchars($selectedPlot['soil_name'] ?? 'N/A') ?> |
                            pH: <?= htmlspecialchars($selectedPlot['ph_value']) ?> |
                            Season: <?= htmlspecialchars($advisory['season']) ?>
                        </p>
                        <h6>Recommended Crops</h6>
                        <p><?= nl2br(htmlspecialchars($advisory['recommended_crops'])) ?></p>
                        <h6>Seed Rate</h6>
                        <p><?= nl2br(htmlspecialchars($advisory['seed_rate'])) ?></p>
                        <h6>Sowing Window</h6>
                        <p><?= nl2br(htmlspecialchars($advisory['sowing_window'])) ?></p>
                        <h6>Fertilization Schedule</h6>
                        <p><?= nl2br(htmlspecialchars($advisory['fertilization_schedule'])) ?></p>
                        <h6>Organic Amendments</h6>
                        <p><?= nl2br(htmlspecialchars($advisory['organic_amendments'])) ?></p>
                        <h6>Pest/Disease Watchlist</h6>
                        <p><?= nl2br(htmlspecialchars($advisory['pest_watchlist'])) ?></p>
                        <div class="mt-3 d-flex gap-2">
                            <button class="btn btn-outline-secondary btn-sm" onclick="window.print()"><i class="bi bi-printer me-1"></i>Print</button>
                            <a href="support_ticket.php?from_advisory=1&plot_id=<?= $selectedPlot['id'] ?>" class="btn btn-outline-success btn-sm">
                                <i class="bi bi-headset me-1"></i>Request Admin Review
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
