<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

$categoryId = isset($_GET['category']) ? (int)$_GET['category'] : null;
$where = "WHERE p.is_active = 1";
$params = [];
if ($categoryId) {
    $where .= " AND p.category_id = ?";
    $params[] = $categoryId;
}

$categoriesStmt = $pdo->query("SELECT id, name FROM categories WHERE is_active = 1 ORDER BY name");
$categories = $categoriesStmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $pdo->prepare("SELECT p.*, c.name AS category_name 
    FROM products p 
    LEFT JOIN categories c ON c.id = p.category_id 
    $where 
    ORDER BY p.created_at DESC");
$stmt->execute($params);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="container my-4">
    <div class="row">
        <div class="col-md-3 mb-3">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h6 class="mb-2">Filter by Category</h6>
                    <ul class="list-unstyled small">
                        <li><a href="catalog.php" class="<?= !$categoryId ? 'fw-bold text-success' : '' ?>">All</a></li>
                        <?php foreach ($categories as $cat): ?>
                            <li>
                                <a href="catalog.php?category=<?= $cat['id'] ?>" class="<?= $categoryId == $cat['id'] ? 'fw-bold text-success' : '' ?>">
                                    <?= htmlspecialchars($cat['name']) ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-9">
            <h3 class="mb-3">Farm Inputs</h3>
            <div class="row g-4">
                <?php foreach ($products as $product): ?>
                    <div class="col-md-4">
                        <div class="card product-card h-100">
                            <?php if (!empty($product['image'])): ?>
                                <img src="uploads/products/<?= htmlspecialchars($product['image']) ?>" class="card-img-top" alt="<?= htmlspecialchars($product['title']) ?>">
                            <?php else: ?>
                                <div class="ratio ratio-4x3 bg-light d-flex align-items-center justify-content-center text-muted">
                                    <i class="bi bi-image fs-1"></i>
                                </div>
                            <?php endif; ?>
                            <div class="card-body d-flex flex-column">
                                <span class="badge bg-success-subtle text-success mb-1"><?= htmlspecialchars($product['category_name'] ?? 'Input') ?></span>
                                <h6 class="card-title"><?= htmlspecialchars($product['title']) ?></h6>
                                <p class="small text-muted mb-2"><?= htmlspecialchars(mb_strimwidth($product['description'], 0, 60, '…')) ?></p>
                                <div class="mt-auto d-flex justify-content-between align-items-center">
                                    <div>
                                        <span class="fw-bold">₹<?= number_format($product['price'], 2) ?></span>
                                    </div>
                                    <a href="product.php?id=<?= $product['id'] ?>" class="btn btn-sm btn-outline-success">
                                        View
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
                <?php if (empty($products)): ?>
                    <p class="text-muted">No products found.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
