CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(120) NOT NULL,
    email VARCHAR(160) NOT NULL UNIQUE,
    phone VARCHAR(40),
    password_hash VARCHAR(255) NOT NULL,
    role VARCHAR(40) NOT NULL DEFAULT 'user',
    status VARCHAR(20) NOT NULL DEFAULT 'active',
    village VARCHAR(120),
    taluk VARCHAR(120),
    district VARCHAR(120),
    state VARCHAR(120),
    pincode VARCHAR(20),
    created_at DATETIME NOT NULL
);

CREATE TABLE IF NOT EXISTS categories (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(120) NOT NULL,
    description TEXT,
    is_active TINYINT(1) NOT NULL DEFAULT 1
);

CREATE TABLE IF NOT EXISTS products (
    id INT AUTO_INCREMENT PRIMARY KEY,
    category_id INT NOT NULL,
    title VARCHAR(200) NOT NULL,
    sku VARCHAR(100),
    price DECIMAL(10,2) NOT NULL,
    mrp DECIMAL(10,2),
    unit VARCHAR(40),
    image VARCHAR(255),
    description TEXT,
    stock INT NOT NULL DEFAULT 0,
    min_stock INT NOT NULL DEFAULT 0,
    is_active TINYINT(1) NOT NULL DEFAULT 1,
    created_at DATETIME NOT NULL,
    FOREIGN KEY (category_id) REFERENCES categories(id)
);

CREATE TABLE IF NOT EXISTS addresses (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    line1 VARCHAR(255) NOT NULL,
    line2 VARCHAR(255),
    village VARCHAR(120),
    taluk VARCHAR(120),
    district VARCHAR(120),
    state VARCHAR(120),
    pincode VARCHAR(20),
    is_default TINYINT(1) NOT NULL DEFAULT 0,
    FOREIGN KEY (user_id) REFERENCES users(id)
);

CREATE TABLE IF NOT EXISTS orders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    address_id INT,
    total_amount DECIMAL(10,2) NOT NULL,
    cod_amount DECIMAL(10,2) NOT NULL,
    status VARCHAR(20) NOT NULL DEFAULT 'Pending',
    notes TEXT,
    delivery_window VARCHAR(255),
    created_at DATETIME NOT NULL,
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (address_id) REFERENCES addresses(id)
);

CREATE TABLE IF NOT EXISTS order_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_id INT NOT NULL,
    product_id INT NOT NULL,
    qty INT NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    FOREIGN KEY (order_id) REFERENCES orders(id),
    FOREIGN KEY (product_id) REFERENCES products(id)
);

CREATE TABLE IF NOT EXISTS soil_types (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(120) NOT NULL,
    ph_min DECIMAL(4,2),
    ph_max DECIMAL(4,2),
    texture VARCHAR(120),
    drainage VARCHAR(120),
    recommended_crops TEXT,
    description TEXT
);

CREATE TABLE IF NOT EXISTS plots (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    name VARCHAR(160) NOT NULL,
    area DECIMAL(10,2),
    area_unit VARCHAR(20),
    soil_type_id INT,
    ph_value DECIMAL(4,2),
    irrigation_type VARCHAR(120),
    previous_crop VARCHAR(120),
    created_at DATETIME NOT NULL,
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (soil_type_id) REFERENCES soil_types(id)
);

CREATE TABLE IF NOT EXISTS soil_tests (
    id INT AUTO_INCREMENT PRIMARY KEY,
    plot_id INT,
    user_id INT,
    ph_value DECIMAL(4,2),
    texture VARCHAR(120),
    organic_matter VARCHAR(40),
    status VARCHAR(20) NOT NULL DEFAULT 'Pending',
    admin_notes TEXT,
    created_at DATETIME NOT NULL,
    FOREIGN KEY (plot_id) REFERENCES plots(id),
    FOREIGN KEY (user_id) REFERENCES users(id)
);

CREATE TABLE IF NOT EXISTS advisory_rules (
    id INT AUTO_INCREMENT PRIMARY KEY,
    soil_type_id INT NOT NULL,
    season VARCHAR(40) NOT NULL DEFAULT 'Any',
    ph_min DECIMAL(4,2) NOT NULL,
    ph_max DECIMAL(4,2) NOT NULL,
    recommended_crops TEXT NOT NULL,
    seed_rate TEXT,
    sowing_window TEXT,
    fertilization_schedule TEXT,
    organic_amendments TEXT,
    pest_watchlist TEXT,
    is_active TINYINT(1) NOT NULL DEFAULT 1,
    FOREIGN KEY (soil_type_id) REFERENCES soil_types(id)
);

CREATE TABLE IF NOT EXISTS knowledge_articles (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    type VARCHAR(20) NOT NULL DEFAULT 'article',
    content TEXT NOT NULL,
    status VARCHAR(20) NOT NULL DEFAULT 'draft',
    created_at DATETIME NOT NULL
);

CREATE TABLE IF NOT EXISTS support_tickets (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    subject VARCHAR(255) NOT NULL,
    message TEXT NOT NULL,
    status VARCHAR(20) NOT NULL DEFAULT 'Open',
    admin_reply TEXT,
    created_at DATETIME NOT NULL,
    updated_at DATETIME,
    FOREIGN KEY (user_id) REFERENCES users(id)
);
