<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

// Fetch some categories and featured products
$categoriesStmt = $pdo->query("SELECT id, name, description FROM categories WHERE is_active = 1 ORDER BY name LIMIT 8");
$categories = $categoriesStmt->fetchAll(PDO::FETCH_ASSOC);

$productsStmt = $pdo->query("SELECT p.*, c.name AS category_name 
    FROM products p 
    LEFT JOIN categories c ON c.id = p.category_id 
    WHERE p.is_active = 1 
    ORDER BY p.created_at DESC 
    LIMIT 8");
$products = $productsStmt->fetchAll(PDO::FETCH_ASSOC);
?>
<section class="hero-section">
    <div class="container">
        <div class="row align-items-center gy-4">
            <div class="col-lg-6">
                <span class="badge badge-soft mb-2"><i class="bi bi-cloud-sun me-1"></i> Smart Agriculture Assistant</span>
                <h1 class="mb-3">Plan your crops. Understand your soil. Shop the right inputs.</h1>
                <p class="lead mb-4">Plan &amp; Soil E-Portal combines crop planning, soil advisory, and farm input e‑commerce into one simple platform, designed for farmers and agri-students.</p>
                <div class="d-flex flex-wrap gap-2">
                    <a href="catalog.php" class="btn btn-light text-success fw-semibold"><i class="bi bi-bag-check me-1"></i> Shop Inputs</a>
                    <a href="advisory.php" class="btn btn-outline-light"><i class="bi bi-graph-up-arrow me-1"></i> Get Smart Advisory</a>
                </div>
                <p class="small mt-3 text-white-75"><i class="bi bi-shield-check me-1"></i>100% demo project – no real payment, Cash on Delivery only.</p>
            </div>
            <div class="col-lg-6">
                <div class="card border-0 shadow-lg">
                    <div class="card-body p-4">
                        <h5 class="mb-3"><i class="bi bi-lightbulb me-1 text-warning"></i> Today’s Seasonal Snippet</h5>
                        <p class="mb-2 small text-muted">Example snippet: For <strong>Rabi season</strong> in loamy soil with pH 6.5–7.5, consider <strong>wheat</strong> with balanced NPK 10:26:26 basal dose.</p>
                        <ul class="small mb-0">
                            <li>✔ Recommended crops based on soil pH and type</li>
                            <li>✔ Simple crop plans with timeline-based tasks</li>
                            <li>✔ Knowledge base for diseases and best practices</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="container my-5">
    <div class="row mb-3 align-items-center">
        <div class="col-md-8">
            <h3 class="mb-0">Shop by Category</h3>
            <p class="text-muted mb-0">Seeds, fertilizers, tools, soil amendments and more.</p>
        </div>
        <div class="col-md-4 text-md-end mt-2 mt-md-0">
            <a href="catalog.php" class="btn btn-outline-success btn-sm">View All Products</a>
        </div>
    </div>
    <div class="mb-4">
        <?php foreach ($categories as $cat): ?>
            <span class="category-pill">
                <i class="bi bi-tag"></i> <?= htmlspecialchars($cat['name']) ?>
            </span>
        <?php endforeach; ?>
    </div>

    <h4 class="mt-4 mb-3">Featured Inputs</h4>
    <div class="row g-4">
        <?php foreach ($products as $product): ?>
            <div class="col-md-3">
                <div class="card product-card h-100">
                    <?php if (!empty($product['image'])): ?>
                        <img src="uploads/products/<?= htmlspecialchars($product['image']) ?>" class="card-img-top" alt="<?= htmlspecialchars($product['title']) ?>">
                    <?php else: ?>
                        <div class="ratio ratio-4x3 bg-light d-flex align-items-center justify-content-center text-muted">
                            <i class="bi bi-image fs-1"></i>
                        </div>
                    <?php endif; ?>
                    <div class="card-body d-flex flex-column">
                        <span class="badge bg-success-subtle text-success mb-1"><?= htmlspecialchars($product['category_name'] ?? 'Input') ?></span>
                        <h6 class="card-title"><?= htmlspecialchars($product['title']) ?></h6>
                        <p class="small text-muted mb-2"><?= htmlspecialchars(mb_strimwidth($product['description'], 0, 70, '…')) ?></p>
                        <div class="mt-auto d-flex justify-content-between align-items-center">
                            <div>
                                <span class="fw-bold">₹<?= number_format($product['price'], 2) ?></span>
                                <?php if (!empty($product['mrp']) && $product['mrp'] > $product['price']): ?>
                                    <small class="text-muted text-decoration-line-through ms-1">₹<?= number_format($product['mrp'], 2) ?></small>
                                <?php endif; ?>
                            </div>
                            <a href="product.php?id=<?= $product['id'] ?>" class="btn btn-sm btn-outline-success">
                                <i class="bi bi-bag-plus"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        <?php if (empty($products)): ?>
            <p class="text-muted">Seed data not loaded yet. Please run <code>seed.php</code> first.</p>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/partials/footer.php'; ?>
