<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

if (empty($_SESSION['user'])) {
    header('Location: login.php'); exit;
}
$userId = $_SESSION['user']['id'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

$stmt = $pdo->prepare("SELECT o.*, a.line1, a.village, a.district, a.pincode 
    FROM orders o 
    LEFT JOIN addresses a ON a.id = o.address_id 
    WHERE o.id = ? AND o.user_id = ?");
$stmt->execute([$id, $userId]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$order) {
    echo "<div class='container my-4'><div class='alert alert-warning'>Order not found.</div></div>";
    include __DIR__ . '/partials/footer.php'; exit;
}
$itemsStmt = $pdo->prepare("SELECT oi.*, p.title FROM order_items oi 
    LEFT JOIN products p ON p.id = oi.product_id 
    WHERE oi.order_id = ?");
$itemsStmt->execute([$id]);
$items = $itemsStmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="container my-4">
    <div class="card shadow-sm">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <h5>Order #<?= $order['id'] ?></h5>
                <span class="badge bg-secondary"><?= htmlspecialchars($order['status']) ?></span>
            </div>
            <p class="small mb-1">Placed on: <?= htmlspecialchars($order['created_at']) ?></p>
            <p class="small mb-3">Deliver to: <?= htmlspecialchars($order['line1'] . ', ' . $order['village'] . ', ' . $order['district'] . ' - ' . $order['pincode']) ?></p>
            <div class="table-responsive mb-3">
                <table class="table table-sm">
                    <thead>
                        <tr><th>Item</th><th>Qty</th><th>Price</th><th>Line Total</th></tr>
                    </thead>
                    <tbody>
                        <?php foreach ($items as $it): ?>
                            <tr>
                                <td><?= htmlspecialchars($it['title']) ?></td>
                                <td><?= (int)$it['qty'] ?></td>
                                <td>₹<?= number_format($it['price'], 2) ?></td>
                                <td>₹<?= number_format($it['price'] * $it['qty'], 2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <p class="fw-bold">Total COD Amount: ₹<?= number_format($order['cod_amount'], 2) ?></p>
            <a href="javascript:window.print()" class="btn btn-outline-secondary btn-sm"><i class="bi bi-printer me-1"></i>Print Invoice</a>
        </div>
    </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
