<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

if (empty($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}
$userId = $_SESSION['user']['id'];

$stmt = $pdo->prepare("SELECT * FROM orders WHERE user_id = ? ORDER BY created_at DESC");
$stmt->execute([$userId]);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="container my-4">
    <h3 class="mb-3">My Orders</h3>
    <?php if (!$orders): ?>
        <p class="text-muted">No orders yet.</p>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table align-middle">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Total</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($orders as $o): ?>
                        <tr>
                            <td>#<?= $o['id'] ?></td>
                            <td>₹<?= number_format($o['cod_amount'], 2) ?></td>
                            <td><span class="badge bg-secondary"><?= htmlspecialchars($o['status']) ?></span></td>
                            <td><?= htmlspecialchars($o['created_at']) ?></td>
                            <td><a href="order_view.php?id=<?= $o['id'] ?>" class="btn btn-sm btn-outline-success">View</a></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
