<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once __DIR__ . '/../config/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= APP_NAME ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Smart agriculture assistance platform for crop planning, soil advisory, and farm input shopping.">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #f4f7fb;
        }
        .navbar-brand span {
            font-weight: 700;
        }
        .hero-section {
            padding: 4rem 0;
            background: linear-gradient(135deg, #0f766e, #22c55e);
            color: #fff;
        }
        .hero-section h1 {
            font-weight: 700;
        }
        .product-card {
            border: none;
            border-radius: 1rem;
            box-shadow: 0 10px 25px rgba(15, 23, 42, 0.08);
            transition: transform 0.15s ease, box-shadow 0.15s ease;
        }
        .product-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 16px 35px rgba(15, 23, 42, 0.14);
        }
        .category-pill {
            border-radius: 999px;
            padding: .4rem 1rem;
            border: 1px solid #e2e8f0;
            background: #fff;
            font-size: .9rem;
            margin: 0.25rem;
            display: inline-flex;
            align-items: center;
            gap: .35rem;
        }
        .main-footer {
            background: #0f172a;
            color: #cbd5f5;
            padding: 2rem 0 1rem;
            margin-top: 3rem;
        }
        .badge-soft {
            background: rgba(16, 185, 129, 0.1);
            color: #0f766e;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm">
    <div class="container">
        <a class="navbar-brand d-flex align-items-center" href="<?= BASE_URL ?>">
            <i class="bi bi-emoji-smile text-success fs-4 me-2"></i>
            <span>Plan &amp; Soil E-Portal</span>
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="mainNavbar">
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item"><a href="<?= BASE_URL ?>" class="nav-link">Home</a></li>
                <li class="nav-item"><a href="<?= BASE_URL ?>knowledge.php" class="nav-link">Knowledge Base</a></li>
                <li class="nav-item"><a href="<?= BASE_URL ?>catalog.php" class="nav-link">Products</a></li>
                <li class="nav-item"><a href="<?= BASE_URL ?>plots.php" class="nav-link">My Plots</a></li>
                <li class="nav-item"><a href="<?= BASE_URL ?>advisory.php" class="nav-link">Smart Advisory</a></li>
                <?php if (!empty($_SESSION['user'])): ?>
                    <li class="nav-item"><a href="<?= BASE_URL ?>orders.php" class="nav-link">Orders</a></li>
                    <li class="nav-item"><a href="<?= BASE_URL ?>cart.php" class="nav-link position-relative">
                        <i class="bi bi-cart3"></i>
                    </a></li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                            <?= htmlspecialchars($_SESSION['user']['name'] ?? 'Account') ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="<?= BASE_URL ?>profile.php">Profile</a></li>
                            <li><a class="dropdown-item" href="<?= BASE_URL ?>logout.php">Logout</a></li>
                        </ul>
                    </li>
                <?php else: ?>
                    <li class="nav-item"><a href="<?= BASE_URL ?>login.php" class="nav-link">Login</a></li>
                    <li class="nav-item"><a href="<?= BASE_URL ?>register.php" class="btn btn-success btn-sm ms-lg-2 mt-1 mt-lg-0">Sign up</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>
<div class="container-fluid px-0">
