<?php
require_once __DIR__ . '/config/db.php';
include __DIR__ . '/partials/header.php';

if (empty($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}
$userId = $_SESSION['user']['id'];

$soilTypes = $pdo->query("SELECT id, name FROM soil_types ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $area = floatval($_POST['area'] ?? 0);
    $areaUnit = $_POST['area_unit'] ?? 'acre';
    $soilTypeId = (int)($_POST['soil_type_id'] ?? 0);
    $ph = $_POST['ph_value'] !== '' ? floatval($_POST['ph_value']) : null;
    $irrigation = trim($_POST['irrigation_type'] ?? '');
    $previousCrop = trim($_POST['previous_crop'] ?? '');
    if ($name !== '') {
        $stmt = $pdo->prepare("INSERT INTO plots (user_id, name, area, area_unit, soil_type_id, ph_value, irrigation_type, previous_crop, created_at) VALUES (?,?,?,?,?,?,?,?, NOW())");
        $stmt->execute([$userId, $name, $area, $areaUnit, $soilTypeId ?: null, $ph, $irrigation, $previousCrop]);
    }
}

$plotsStmt = $pdo->prepare("SELECT p.*, s.name AS soil_name FROM plots p LEFT JOIN soil_types s ON s.id = p.soil_type_id WHERE p.user_id = ? ORDER BY p.created_at DESC");
$plotsStmt->execute([$userId]);
$plots = $plotsStmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="container my-4">
    <div class="row g-4">
        <div class="col-md-5">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5 class="mb-3">Add Plot</h5>
                    <form method="post">
                        <div class="mb-2">
                            <label class="form-label">Plot Name</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="row g-2 mb-2">
                            <div class="col-6">
                                <label class="form-label">Area</label>
                                <input type="number" step="0.01" name="area" class="form-control">
                            </div>
                            <div class="col-6">
                                <label class="form-label">Unit</label>
                                <select name="area_unit" class="form-select">
                                    <option value="acre">Acre</option>
                                    <option value="hectare">Hectare</option>
                                </select>
                            </div>
                        </div>
                        <div class="mb-2">
                            <label class="form-label">Soil Type</label>
                            <select name="soil_type_id" class="form-select">
                                <option value="">Select soil</option>
                                <?php foreach ($soilTypes as $s): ?>
                                    <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['name']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="row g-2 mb-2">
                            <div class="col-6">
                                <label class="form-label">Known pH (optional)</label>
                                <input type="number" step="0.01" name="ph_value" class="form-control">
                            </div>
                            <div class="col-6">
                                <label class="form-label">Irrigation</label>
                                <input type="text" name="irrigation_type" class="form-control" placeholder="Canal / Borewell">
                            </div>
                        </div>
                        <div class="mb-2">
                            <label class="form-label">Previous Crop</label>
                            <input type="text" name="previous_crop" class="form-control">
                        </div>
                        <button class="btn btn-success w-100 mt-2" type="submit">Save Plot</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-7">
            <h3 class="mb-3">My Plots</h3>
            <?php if (!$plots): ?>
                <p class="text-muted">No plots added yet.</p>
            <?php else: ?>
                <div class="list-group">
                    <?php foreach ($plots as $p): ?>
                        <a href="advisory.php?plot_id=<?= $p['id'] ?>" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                            <div>
                                <div class="fw-semibold"><?= htmlspecialchars($p['name']) ?></div>
                                <div class="small text-muted">
                                    <?= htmlspecialchars($p['area'] . ' ' . $p['area_unit']) ?> |
                                    Soil: <?= htmlspecialchars($p['soil_name'] ?? 'N/A') ?> |
                                    pH: <?= $p['ph_value'] !== null ? htmlspecialchars($p['ph_value']) : 'N/A' ?>
                                </div>
                            </div>
                            <span class="badge bg-success-subtle text-success">Get Advisory</span>
                        </a>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
